//
//  バージョンアップ時コモン ver1.02
//
// ------------------------------------------------------
// Copyright (c) 2016 Yana
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
// ------------------------------------------------------
//
// author Yana
//

var Imported = Imported || {};
Imported['VersionUpCommon'] = 1.02;

/*:
 * @plugindesc ver1.02/設定バージョンと記録バージョンが違うとき、コモンイベントの起動を予約します。
 * @author Yana
 * 
 * @param Game Version
 * @desc ゲームのバージョンです。
 * Format: [Alpha|Beta][major.minor.revision]
 * @type number
 * @default 1.00
 * 
 * @param Reserve Common ID
 * @desc バージョンが違う場合実行するコモンイベントのIDです。
 * @default 2
 * 
 * @param Show Game Version
 * @desc ゲームのバージョンをタイトルに表示するかの設定です。
 * true/falseで設定してください。
 * @default true
 * 
 * @param Version Text
 * @desc タイトルに表示するバージョンの前に追加するテキストです。
 * @default version.
 * 
 * @param Position X
 * @desc タイトルのバージョンの位置X座標です。
 * @default 572
 * 
 * @param Position Y
 * @desc タイトルのバージョンの位置Y座標です。
 * @default 594
 * 
 * @param Text Alignment
 * @desc テキストのアライメントです。
 * left,center,rightのいずれかを指定してください。
 * @default right
 * 
 * @help------------------------------------------------------
 *  プラグインコマンドはありません。
 * ------------------------------------------------------
 * ------------------------------------------------------ 
 * 設定方法
 * ------------------------------------------------------ 
 * 
 * プラグインパラメータで、バージョンが違った際実行するコモンイベントIDを指定してください。
 * 現在のゲームのバージョンは、$gameSystem._gameVersionで、
 * 更新前のゲームのバージョンは$gameSystem._preVersionで取得できます。
 * 
 * 現在のバージョンを条件にイベントコマンドで分岐を行う際は、条件分岐→スクリプトで、
 * $gameSystem._gameVersion === 'ゲームのバージョン'
 * 
 * 更新前のバージョンを条件にイベントコマンドで分岐を行う際は、条件分岐→スクリプトで、
 * $gameSystem._preVersion === 'ゲームのバージョン'
 * 
 * で判定してください。
 * 
 * コモンイベントの作成例は、添付の画像を参照してください。
 * このように作成すると、
 * 1.0.0→1.0.3に更新:1.01~1.03までのすべての更新内容を通る
 * 1.0.2→1.0.3に更新:1.03の更新内容のみ通る。
 * というような挙動になるので、必要な更新内容のみを通すことができます。
 * 
 * ------------------------------------------------------
 * 利用規約
 * ------------------------------------------------------
 * 当プラグインはMITライセンスで公開されています。
 * 使用に制限はありません。商用、アダルト、いずれにも使用できます。
 * 二次配布も制限はしませんが、サポートは行いません。
 * 著作表示は任意です。行わなくても利用できます。
 * 要するに、特に規約はありません。
 * バグ報告や使用方法等のお問合せはネ実ツクールスレ、または、Twitterにお願いします。
 * https://twitter.com/yanatsuki_
 * 素材利用は自己責任でお願いします。
 * ------------------------------------------------------
 * 更新履歴:
 * ver1.02:
 * プラグインパラメータの設定の一部が反映されていなかったのを修正
 * ver1.01:
 * ヘルプを追加
 * プラグインパラメータの説明を一部修正
 * ver1.00:
 * 公開
 */

(function(){

    'use strict';
    
    var parameters = PluginManager.parameters('VersionUpCommon');
    var gameVersion = String(parameters['Game Version']);
    var reserveCommonId = Number(parameters['Reserve Common ID']);
    var showGameVersion = parameters['Show Game Version'] === 'true';
    var versionText = String(parameters['Version Text']);
    var posX = Number(parameters['Position X'] || 572);
    var posY = Number(parameters['Position Y'] || 594);
    var textAlign = Number(parameters['Text Alignment'] || 'right');
    
    var getVersionString = function(versionNum) {
        var type = parseInt(versionNum / 1000000);
        var major = parseInt(versionNum / 10000) % 100;
        var minor = parseInt(versionNum / 100) % 100;
        var revision = versionNum % 100;
        var strFormat = '';
        switch (type) {
            case 0:
                strFormat = 'Alpha %1.%2.%3';    break;
            case 1:
                strFormat = 'Beta %1.%2.%3';     break;
            default:
                strFormat = 'Version %1.%2.%3'
        }
        return strFormat.format(major, minor, revision);
    };
    
    var parseVersionString = function(strVersion) {
        var verFormat = strVersion.match(/(?:(ALPHA|BETA)\s)?(\d+)\.(\d+)\.(\d+)/i);
        if (verFormat) {
            var type = RegExp.$1
            var major = Number(RegExp.$2);
            var minor = Number(RegExp.$3);
            var revision = Number(RegExp.$4);
            var typeNum = 2;
            if (type.toUpperCase() === 'ALPHA') {
              typeNum = 0;
            } else if (type.toUpperCase() === 'BETA') {
              typeNum = 1;
            } else {
              if (major > 0) typeNum = 2;
              else           typeNum = 0;
            }
            var versionNumber = typeNum * 1000000 + major * 10000 + minor * 100 + revision;
            return versionNumber;
        }
    };
    var currentVersionNumber = parseVersionString(gameVersion);
    
    var _vr_cmn_GSystem_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _vr_cmn_GSystem_initialize.call(this);
        this._gameVersion = currentVersionNumber;
    };
    
    Game_System.prototype.getVersionString = function() {
        return versionText + gameVersion;
    };
    
    var _vr_cmn_SMap_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function(){
        _vr_cmn_SMap_start.call(this);
        this.checkVersion();
    };

    Scene_Map.prototype.checkVersion = function() {
        if ($gameSystem._gameVersion !== currentVersionNumber){
            $gameSystem._preVersion = $gameSystem._gameVersion;
            if (typeof $gameSystem._preVersion === 'string') {
                console.log('prevStr:' + $gameSystem._preVersion);
                $gameSystem._preVersion = parseVersionString($gameSystem._preVersion);
                console.log('prevNum:' + $gameSystem._preVersion);
            }
            $gameSystem._gameVersion = currentVersionNumber;
            $gameTemp.reserveCommonEvent(reserveCommonId);
        }
    };
    
    var _vr_cmn_STitle_create = Scene_Title.prototype.create;
    Scene_Title.prototype.create = function() {
        _vr_cmn_STitle_create.call(this);
        if (showGameVersion) this.createVersionSprite();
    };
    
    Scene_Title.prototype.createVersionSprite = function() {
        var platformText = "";
        var x = posX;
        var y = posY;
        var w = 240;
        var h = 24;
        
        if (Utils.isNwjs()) {
            if (Utils.isOptionValid('test')) {
                platformText = 'PC Debug';
            } else {
                platformText = 'PC Standalone';
            }
        } else {
            if (window.RPGAtsumaru !== undefined) {
                if (Utils.isMobileDevice()) {
                    platformText = 'Atsumaru Mobile';
                } else {
                    platformText = 'Atsumaru PC';
                }
            } else if (Utils.isMobileDevice()) {
                if (Utils.isMobileSafari() || Utils.isAndroidChrome()) {
                    platformText = 'Mobile Browser';
                } else {
                    platformText = 'Mobile App';
                }
            } else {
                platformText = 'PC Browser';
            }
        }
        platformText = ' (' + platformText + ')';
        
        this._verSprite = new Sprite(new Bitmap(w,h));
        this._verSprite.setFrame(0,0,w,h);
        this._verSprite.x = x;
        this._verSprite.y = y;
        this.addChild(this._verSprite);
        this._verSprite.bitmap.fontSize = 18;
        this._verSprite.bitmap.drawText(versionText + gameVersion + platformText,0,0,w,h,textAlign);
    };
    
}());
